 
'-------- Bosch KF161 2764 Eprom program voor 40 kanalen (PA0PDO) ----------
 
  DIM D$(80, 1): DEFINT I-K, T: lijst$ = "PA0XYZ.LST"
  ON ERROR GOTO foutopvang
  OPEN "KF161.INI" FOR INPUT AS #1: INPUT #1, lijst$: CLOSE #1

  COLOR 15, 1: CLS : PRINT : COLOR 0, 7: LOCATE 2, 11
  PRINT ; "  Eprom bestand aanmaken voor 40 kanaals KF161  (PA0PDO)  "
  COLOR 15, 1: PRINT
  PRINT TAB(30); " BELANGRIJK !"
  PRINT TAB(11); "Zorg voor een lijst op papier van de door U gewenste freq."
  PRINT TAB(11); "Bewerk de lijst met de editor (muis ondersteund)"
  PRINT TAB(11); "Sla op met ALT  B  L": PRINT
  PRINT TAB(11); "Frequentie lijst bestandnaam: "; lijst$
herhaal:
   LOCATE 9, 41: INPUT "", a$: IF a$ <> "" THEN lijst$ = a$
   IF LEN(lijst$) > 12 THEN
     LOCATE 10, 11: PRINT "Ongeldige naam!"; TAB(41); "PA0XYZ.LST"
     GOTO herhaal
   END IF
   LOCATE 9, 41 + LEN(lijst$): PRINT STRING$(39 - LEN(lijst$), 32)
   PRINT STRING$(51, 32)
   oproep$ = "edit " + lijst$
   SHELL oproep$

'---------------------- 80 eprom adressen berekenen -----------------------
  '8191 = hoogste eprom adres van een 2764
  ' 256 = offset voor debug = 100hex
   tel = 0
   FOR J = 0 TO 7
     FOR I = 0 TO 9
       adres = 8191 - (J * 1024) - (2 ^ I)
       tel = tel + 1
       D$(tel, 0) = HEX$(adres + 256)
   NEXT I, J
'-------------- de ingevoerde freq controleren op geldigheid ---------------
 
  kan$ = UCASE$(LEFT$(lijst$, LEN(lijst$) - 4) + ".kan")
  OPEN kan$ FOR OUTPUT AS #4
  PRINT #4, "     FREQUENTIES    KF161    " + LEFT$(kan$, LEN(kan$) - 4)
  PRINT #4,

test:
  OPEN lijst$ FOR INPUT AS #2
  LINE INPUT #2, dummy$: LINE INPUT #2, dummy$     'bovenste 2 lijnen lezen
  DEFDBL A: kan = 0: tel = 0

 FOR k = 1 TO 4
   FOR J = 0 TO 1
     LINE INPUT #2, dummy$                 'tabelkop lezen
       FOR I = 1 TO 10
         kan = kan + 1: tel = tel + 1
         LINE INPUT #2, freq$
         C = VAL(LEFT$(freq$, 8))  ' linkse 8 tekens lezen
         LOCATE 11, 11
       
         IF C < 144437.5 THEN
           IF J THEN
           PRINT "Zend kanaal"; kan - 10;
           ELSE PRINT "Ontv kanaal"; kan;
           END IF
           PRINT "   freq"; C; "= te laag!  minimaal 144437.5"
           PRINT TAB(11); "<enter>"
           DO: P$ = INKEY$: LOOP UNTIL P$ = CHR$(13)
           CLOSE #2: SHELL oproep$: GOTO test
         END IF
       
         IF C >= 146000 THEN
           IF J THEN
           PRINT "Zend kanaal"; kan - 10;
           ELSE PRINT "Ontv kanaal"; kan;
           END IF
           PRINT "   freq"; C; "= te hoog!  maximaal 145987.5"
           PRINT TAB(11); "<enter>"
           DO: P$ = INKEY$: LOOP UNTIL P$ = CHR$(13)
           CLOSE #2: SHELL oproep$: GOTO test
         END IF
          
         IF (C / 12.5) <> INT(C / 12.5) THEN
           IF J THEN
           PRINT "Zend kanaal"; kan - 10;
           ELSE PRINT "Ontv kanaal"; kan;
           END IF
           PRINT "   freq"; C; "= geen 12.5kHz rasterfreq.    "
           PRINT TAB(11); "<enter>"
           DO: P$ = INKEY$: LOOP UNTIL P$ = CHR$(13)
           CLOSE #2: SHELL oproep$: GOTO test
         END IF
        
         C$ = STR$((C - 10700) / 12.5)                 'byte berekenen
         B = VAL(MID$(C$, 2, 3)): a = VAL(RIGHT$(C$, 2))
         a = (NOT a) AND 255
         IF B = 108 THEN
              D$(tel, 1) = HEX$(a AND 127)             'byte -> D$(80,1)
         ELSE D$(tel, 1) = HEX$(a OR 128)
         END IF
         IF J = 0 THEN PRINT #4, "      " + freq$
       NEXT I, J
     PRINT #4,
     kan = kan - 10
   NEXT k
  CLOSE
 
  PRINT "Goed nieuws.... Uw frequenties gecontroleerd en ok!          "
  PRINT TAB(11); "<toets>"
  DO: P$ = INKEY$: LOOP UNTIL P$ <> ""

'------------------ samen voegen van adresen en bytes -----------------------
 
  a$ = "40 kanaals kf161" + LEFT$(lijst$, LEN(lijst$) - 4)
  FOR I = 1 TO LEN(a$)
   ident$ = ident$ + " " + HEX$(ASC(MID$(a$, I, 1)))
  NEXT
  ident$ = "e 100" + ident$

  OPEN "64debug.lst" FOR OUTPUT AS #3
  PRINT #3, "f 0100 2100 FF"    'fill  0000--> 2000 met FF
  PRINT #3, ident$              '40 kanaals kf161 PA0XYZ
  'debug formaat:  e adres byte   --> e FFFA 7B
  FOR I = 1 TO 80
    PRINT #3, "e  "; D$(I, 0); "   "; D$(I, 1)
  NEXT I
  PRINT #3, "r cx"                'register cx
  PRINT #3, "2000"                'load 2000h
  PRINT #3, "n FIK64.BIN"         'output file name
  PRINT #3, "w 0100"              'write offset
  PRINT #3, "q"                   'quit debug
  CLOSE #3                        'sluit fik64.bin

'-------------- zet bestand 64debug.lst om in FIK64.BIN ---------------------
 
  SHELL "debug < 64debug.lst"
 
  CLS : PRINT
  PRINT "    Klaar, nu nog FIK64.BIN in een eprom (laten) branden."
  PRINT "    Selecteer het juiste type eprom en vul het werkgeheugen met FFhex"
  PRINT "    Gebruik onderstaande start adressen bij het laden van FIK64.BIN"
  PRINT
  PRINT "    2764  eprom "; CHR$(26); " 0000hex          27256 eprom "; CHR$(26); " 6000hex"
  PRINT "    27128 eprom "; CHR$(26); " 2000hex          27512 eprom "; CHR$(26); " E000hex"
  PRINT
  PRINT "                                                              1Ŀ28"
  PRINT "    Buig A11 en A12 (pootjes 23,2) buiten voetje,soldeer      2       "
  PRINT "    van hier 100k weerstandjes naar de + 5V aansluiting               "
  PRINT "    Trek 2 draadjes vanaf midden kontakt van de                       23"
  PRINT "    schakelaars I en II naar pootjes 23 en 2.                    Ŀ  "
  PRINT "                                                                   "
  PRINT "    Heeft U voldoende aan 20 kanalen laat dan het draadje              "
  PRINT "    tussen schakelaar II en pootje 2 achterwege.                      "
  PRINT "                                                                      "
  PRINT "                                                             1415"
  PRINT : PRINT : PRINT
  PRINT "    nb:  Het bestand "; kan$; " bevat het frequentie overzicht."
  LOCATE 24, 5: COLOR 0, 7
  PRINT " Veel plezier met uw 40 kanaals KF161!   PA0PDO@PI8SHB <toets>";
  COLOR 15, 1
  DO: P$ = INKEY$: LOOP UNTIL P$ <> ""
  OPEN "KF161.INI" FOR OUTPUT AS #4: PRINT #4, lijst$: CLOSE #4
  SHELL "DEL 64DEBUG.LST"
  SYSTEM

foutopvang:
  IF ERR = 53 THEN CLOSE #1
  RESUME NEXT




